<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * CodeIgniter Inngrid Class
 *
 * Communicates with api.innGrid.net to acquire companies' information
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Libraries
 * @author		Jaeyun Noh
 * @link		
 */
class Inngrid {
	

	/**
	 * Constructor - Sets API Preferences
	 *
	 * The constructor can be passed an array of config values
	 */

	public function __construct($company_id = '')
	{
		$this->ci =& get_instance();
		$this->ci->load->library('Format');
		$this->ci->load->spark('restclient/2.2.1');
		// $config = array(
		// 			'server'            => "http://api.roomsy.com/",
		// 			//'server'            => "http://localhost/innGrid/api",
		// 			'api_key'         => "35ccf8d14d30d4909015a639f2c5cdfd"
		//                 );
		// $this->ci->rest->initialize($config);

	}

	// acquire company's general information + image links
	function get_company($uri)
	{
		$param = array('uri' => $uri);
		return $this->_get("v1/company", $param, "json");
	}

	// acquire company's general information + image links
	function get_room_types($company_id)
	{
		$param = array('company_id' => $company_id);
		return $this->_get("v1/room_types", $param, "json");
	}



	function _get($url, $param = "", $format = NULL)
	{
		$val = $this->ci->rest->get($url, $param, $format);
		//$this->ci->rest->debug();
		return $this->ci->format->factory($val)->to_array();

	}
}
